<?php
if (!defined('ABSPATH')) {
    exit; 
}

function dworkers_save_post(WP_REST_Request $request) {
    $category_id = sanitize_text_field($request->get_param('category_id'));
    $title = sanitize_text_field($request->get_param('title'));
    $keyword = sanitize_text_field($request->get_param('keyword'));
    $excerpt = sanitize_textarea_field($request->get_param('excerpt'));
    $content = wp_kses_post($request->get_param('content'));
    $status = $request->get_param('status') === 'publish' ? 'publish' : 'draft';
    $image_url = esc_url_raw($request->get_param('image'));
    $image_name = sanitize_text_field($request->get_param('imageName')) . '.png';
    $image_alt = sanitize_text_field($request->get_param('imageAlt'));

    $post_data = array(
        'post_title'   => $title,
        'post_excerpt' => $excerpt,
        'post_content' => $content,
        'post_status'  => $status,
        'post_type'    => 'post',
        'post_category'=> array($category_id),
    );

    $post_id = wp_insert_post($post_data);

    if (!is_wp_error($post_id)) {
        update_post_meta($post_id, '_yoast_wpseo_title', $title);
        update_post_meta($post_id, '_yoast_wpseo_metadesc', $excerpt);
        update_post_meta($post_id, '_yoast_wpseo_focuskw', $keyword);

        $image_data = wp_remote_get($image_url);
        $image_contents = wp_remote_retrieve_body($image_data);
        $upload = wp_upload_bits($image_name, null, $image_contents);
        $wp_filetype = wp_check_filetype($upload['file'], null);
        $attachment = array(
            'post_mime_type' => $wp_filetype['type'],
            'post_title'     => sanitize_file_name($image_name),
            'post_content'   => '',
            'post_status'    => 'inherit'
        );

        $attachment_id = wp_insert_attachment($attachment, $upload['file'], $post_id);
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        $attach_data = wp_generate_attachment_metadata($attachment_id, $upload['file']);
        wp_update_attachment_metadata($attachment_id, $attach_data);

        set_post_thumbnail($post_id, $attachment_id);
        update_post_meta($attachment_id, '_wp_attachment_image_alt', $image_alt);

        wp_send_json_success(array(
            'message'  => 'Post guardado con éxito',
            'post_id'  => $post_id,
            'edit_url' => get_edit_post_link($post_id, 'raw'),
            'post_url' => get_permalink($post_id),
            'category' => $category_id,
        ));
    } else {
        wp_send_json_error(array('message' => 'No se pudo crear el post.'));
    }
}

function dworkers_save_comment($post_id, $comment, $name, $email) {
    /* Eliminar comillas */
    $email = str_replace('"', '', $email);
    $name = str_replace('"', '', $name);
    $comment = str_replace('"', '', $comment);

    /* eliminar comillas simples */
    $email = str_replace("'", '', $email);
    $name = str_replace("'", '', $name);
    $comment = str_replace("'", '', $comment);

    /* replace ejemplo.com with gmail */
    $email = str_replace('ejemplo', 'gmail', $email);
    $email = str_replace('example', 'gmail', $email);

    $commentdata = array(
        'comment_post_ID' => $post_id,
        'comment_author' => $name,
        'comment_author_email' => $email,
        'comment_content' => $comment,
        'comment_type' => '',
        'comment_approved' => 1,
    );

    $comment_id = wp_insert_comment($commentdata);

    if (!is_wp_error($comment_id)) {
        return array(
            'message' => 'Comentario guardado con éxito',
            'comment_id' => $comment_id,
        );
    } else {
        return array('message' => 'No se pudo guardar el comentario.');
    }
}
