<?php
// Evitar el acceso directo al archivo
if (!defined('ABSPATH')) {
    exit;
}

class Dworkers_AI_SEO {
    public static function generate_seo_image_name($api_key, $model, $title) {
        $version = get_option('dworkers_content_seo_agent_version', 'free');
        if ($version !== 'free') {
            $token = get_option('dworkers_content_seo_agent_token', '');
            $response = wp_remote_post('https://app.markplanner.co/api/plugin/api_key', array(
                'body' => [
                    'token' => $token
                ]
            ));

            if (!is_wp_error($response)) {
                $body = json_decode(wp_remote_retrieve_body($response), true);
                if (isset($body['api_key'])) {
                    $api_key = $body['api_key'];
                    $provider = 'OpenAI';
                }
            }
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/chat/completions');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
            'model' => $model,
            'messages' => [
                [
                    'role' => 'user',
                    'content' => "Genera solo un nombre, nada más, que no sea muy extenso, por ejemplo: practicas-seguridad-wordpress, para la imagen que sea bueno para seo en relación con el título: " . $title . ". No lo pongas entre comillas ni añadas más texto."
                ]
            ],
            'temperature' => 0.7
        ]));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $api_key,
            'Content-Type: application/json'
        ]);

        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if ($err) {
            return ['success' => false, 'message' => 'Error de cURL: ' . $err];
        } else {
            $result = json_decode($response, true);
            if (isset($result['choices'][0]['message']['content'])) {
                $seo_image_name = trim($result['choices'][0]['message']['content']);
                $seo_image_name = str_replace('"', '', $seo_image_name);
                $seo_image_name = str_replace('\'', '', $seo_image_name);
                return ['success' => true, 'seo_image_name' => $seo_image_name];
            } else {
                return ['success' => false, 'message' => 'Respuesta inesperada de la API'];
            }
        }
    }
}
