<?php
// Evitar el acceso directo al archivo
if (!defined('ABSPATH')) {
    exit;
}

class Dworkers_AI_Image {
    public static function generate_image($api_key, $title) {
        $images = get_option('dworkers_content_seo_agent_version', 'OpenAI');
        if ($images === 'zeroazul' || $api_key == '') {
            $url = 'https://automation.zeroazul.com/webhook/0b1554dc-ee70-4dc4-b80a-f8b2afd11573';
            $body = array(
                'token' => get_option('dworkers_content_seo_agent_token', ''),
                'prompt' => "Genera una foto de stock limpia y minimalista que parezca muy realista y moderna, con baja saturación. La imagen puede incluir personas o no tener presencia humana. Asegúrate de que no haya texto en ninguna parte de la imagen. El tema de la foto debe ser {$title}. La foto no debe parecer una ilustración, sino una fotografía real tomada con una cámara",
                'title' => $title,
            );

            $response = wp_remote_post($url, array(
                'body' => $body,
                'timeout' => 60
            ));

            if (is_wp_error($response)) {
                return array('success' => false, 'message' => $response->get_error_message());
            }

            $data = json_decode(wp_remote_retrieve_body($response), true);

            if (isset($data['image'])) {
                return array('success' => true, 'url' => $data['image']);
            } else {
                return array('success' => false, 'message' => 'No se pudo generar la imagen');
            }
        } else {
            $url = 'https://api.openai.com/v1/images/generations';
            $body = array(
                'model' => 'dall-e-3',
                'prompt' => "Genera una foto de stock limpia y minimalista que parezca muy realista y moderna, con baja saturación. La imagen puede incluir personas o no tener presencia humana. Asegúrate de que no haya texto en ninguna parte de la imagen. El tema de la foto debe ser {$title}. La foto no debe parecer una ilustración, sino una fotografía real tomada con una cámara",
                'n' => 1,
                'size' => '1024x1024'
            );

            $response = wp_remote_post($url, array(
                'headers' => array(
                    'Authorization' => 'Bearer ' . $api_key,
                    'Content-Type' => 'application/json'
                ),
                'body' => json_encode($body),
                'timeout' => 60
            ));

            $data = json_decode(wp_remote_retrieve_body($response), true);

            if (isset($data['data'][0]['url'])) {
                return array('success' => true, 'url' => $data['data'][0]['url']);
            } else {
                return array('success' => false, 'message' => 'No se pudo generar la imagen');
            }
        }
    }

    public static function generate_image_alt($api_key, $model, $title) {
        $version = get_option('dworkers_content_seo_agent_version', 'free');
        if ($version !== 'free') {
            $token = get_option('dworkers_content_seo_agent_token', '');
            $response = wp_remote_post('https://app.markplanner.co/api/plugin/api_key', array(
                'body' => [
                    'token' => $token
                ]
            ));

            if (!is_wp_error($response)) {
                $body = json_decode(wp_remote_retrieve_body($response), true);
                if (isset($body['api_key'])) {
                    $api_key = $body['api_key'];
                    $provider = 'OpenAI';
                }
            }
        }

        $url = 'https://api.openai.com/v1/chat/completions';
        $body = array(
            'model' => $model,
            'messages' => array(
                array(
                    'role' => 'user',
                    'content' => "Genera un texto corto ALT descriptivo y optimizado para SEO para una imagen relacionada con el siguiente título: {$title}. El texto ALT debe ser conciso pero informativo. No lo pongas entre comillas ni añadas más texto."
                )
            ),
            'temperature' => 0.7
        );

        $response = wp_remote_post($url, array(
            'headers' => array(
                'Authorization' => 'Bearer ' . $api_key,
                'Content-Type' => 'application/json'
            ),
            'body' => json_encode($body),
            'timeout' => 60
        ));

        if (is_wp_error($response)) {
            return array('success' => false, 'message' => $response->get_error_message());
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);

        if (isset($body['choices'][0]['message']['content'])) {
            $alt = trim($body['choices'][0]['message']['content']);
            $alt = str_replace('"', '', $alt);
            $alt = str_replace('\'', '', $alt);
            return array('success' => true, 'alt' => $alt);
        } else {
            return array('success' => false, 'message' => 'No se pudo generar el texto ALT');
        }
    }
}
