<?php
// Evitar el acceso directo al archivo
if (!defined('ABSPATH')) {
    exit;
}

class Dworkers_AI_Comment {
    public static function generate_comment($api_key, $model, $style, $title, $excerpt) {
        $prompt = "Simula un comentario muy corto de una persona Colombiana con estilo $style, humano, sin admiraciones o exaltaciones, comentario corto y con lenguaje natural, que no parezca generado con AI, simular la escritura de una persona real, busca responder el articulo no ofrecer ni vender nada, puede tener errores de escritura, sencillo, que no use cosas como 'estoy emocionado', evita adjetivos, debe ser sencillo, como habla la gente normalemente, evita los adjetivos o comentarios emocionales, no es una explicacion o extensión del post sino una opinion o pregunta en estilo  $style corta del mismo, el tema es $title: $excerpt.";
        return self::make_openai_request($api_key, $prompt, $model);
    }

    public static function generate_name($api_key, $model) {
        $prompt = "Genera un nombre único colombiano y variado para una persona de origen latino. Evita repetir nombres comunes como Carlos y no uses mas de 1 apellido, es decir solo un nombre y un apellido, al azar elige si solo das el nombre completo o solo el nickname, nunca ambos, solo devuelve el nombre o el nickname no la mezcla de los dos, solo devuelve uno de las dos opciones, no incluya la plabra Nickname o Nombre completo";
        return self::make_openai_request($api_key, $prompt, $model);
    }

    public static function generate_email($api_key, $model, $name) {
        $prompt = "inventa una, solo 1, direccion de correo electronico, debe incluir @, aleatoriamente usar el nombre o el nombre con numero o variacion del nombre, debe ser conn una de estas extensiones gmail, hotmail, yahoo, HubSpot, ProtonMail, iCloud, Zoho, Outlook, Mailbox, para el usuario $name";
        return self::make_openai_request($api_key, $prompt, $model);
    }

    public static function get_random_post() {
        if (!function_exists('get_posts')) {
            require_once(ABSPATH . 'wp-includes/post.php');
        }

        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => 1,
            'orderby'        => 'rand'
        );

        $random_post_query = new WP_Query($args);

        if ($random_post_query->have_posts()) {
            $random_post_query->the_post();
            $post_id = get_the_ID();
            wp_reset_postdata();
            return $post_id;
        }

        return null; // Return null if no posts are found
    }

    private static function make_openai_request($api_key, $prompt, $model = 'gpt-4', $max_retries = 3) {
        $attempt = 0;
        $timeout = 120;

        $version = get_option('dworkers_content_seo_agent_version', 'free');
        if ($version !== 'free') {
            $token = get_option('dworkers_content_seo_agent_token', '');
            $response = wp_remote_post('https://app.markplanner.co/api/plugin/api_key', array(
                'body' => [
                    'token' => $token
                ]
            ));

            if (!is_wp_error($response)) {
                $body = json_decode(wp_remote_retrieve_body($response), true);
                if (isset($body['api_key'])) {
                    $api_key = $body['api_key'];
                    $provider = 'OpenAI';
                }
            }
        }

        while ($attempt < $max_retries) {
            error_log("Intento " . ($attempt + 1) . " de solicitud a OpenAI para prompt: " . substr($prompt, 0, 100) . "...");

            $args = array(
                'timeout' => $timeout,
                'headers' => array(
                    'Authorization' => 'Bearer ' . $api_key,
                    'Content-Type' => 'application/json'
                ),
                'body' => json_encode(array(
                    'model' => $model,
                    'messages' => array(
                        array('role' => 'user', 'content' => $prompt)
                    ),
                    'temperature' => 0.7
                ))
            );

            error_log("Cuerpo de la solicitud: " . $args['body']);

            $response = wp_remote_post('https://api.openai.com/v1/chat/completions', $args);

            if (is_wp_error($response)) {
                error_log("Error en la solicitud a OpenAI: " . $response->get_error_message());
                $attempt++;
                continue;
            }

            $body = json_decode(wp_remote_retrieve_body($response), true);
            $http_code = wp_remote_retrieve_response_code($response);

            error_log("Respuesta de OpenAI. Código HTTP: " . $http_code);
            error_log("Cuerpo de la respuesta: " . print_r($body, true));

            if ($http_code === 200 && isset($body['choices'][0]['message']['content'])) {
                error_log("Contenido generado con éxito");
                return array('success' => true, 'content' => trim($body['choices'][0]['message']['content']));
            } else {
                error_log("Respuesta inesperada de OpenAI. Código HTTP: " . $http_code);
                $attempt++;
            }
        }

        error_log("Se agotaron los intentos de solicitud a OpenAI");
        return array('success' => false, 'message' => 'No se pudo generar el contenido después de ' . $max_retries . ' intentos');
    }
}