<?php

add_action('rest_api_init', function () {
    register_rest_route('dworkers/v1', '/settings', array(
        'methods' => 'GET',
        'callback' => 'dworkers_get_settings',
        'permission_callback' => '__return_true',
    ));
    register_rest_route('dworkers/v1', '/settings', array(
        'methods' => 'POST',
        'callback' => 'dworkers_post_settings',
        'permission_callback' => '__return_true',
    ));
});

function dworkers_get_settings() {
    $version = get_option('dworkers_content_seo_agent_version', 'free');
    $api_key = get_option('dworkers_content_seo_agent_api_key', '');
    $provider = get_option('dworkers_content_seo_agent_ai_provider', 'OpenAI');
    $images = get_option('dworkers_content_seo_agent_ai_images', 'OpenAI');
    $model = get_option('dworkers_content_seo_agent_ai_model', '');
    $generate_category = get_option('dworkers_content_seo_agent_generate_category', 0);
    $activate_seo = get_option('dworkers_content_seo_agent_activate_seo', 0);
    $create_comments = get_option('dworkers_content_seo_agent_create_comments', 0);
    $token = get_option('dworkers_content_seo_agent_token', '');

    return new WP_REST_Response([
        'version' => $version,
        'api_key' => $api_key,
        'provider' => $provider,
        'images' => $images,
        'model' => $model,
        'generate_category' => $generate_category,
        'activate_seo' => $activate_seo,
        'create_comments' => $create_comments,
        'token' => $token,
    ], 200);
}

function dworkers_post_settings(WP_REST_Request $request) {
    $version = $request->get_param('version');
    $api_key = $request->get_param('api_key');
    $provider = $request->get_param('provider');
    $images = $request->get_param('images');
    $model = $request->get_param('model');
    $generate_category = $request->get_param('generate_category');
    $activate_seo = $request->get_param('activate_seo');
    $create_comments = $request->get_param('create_comments');
    $token = $request->get_param('token');
    if ($token !== get_option('dworkers_content_seo_agent_token', '')) {
        $token = md5($token);
    }

    update_option('dworkers_content_seo_agent_version', $version);
    update_option('dworkers_content_seo_agent_api_key', $api_key);
    update_option('dworkers_content_seo_agent_ai_provider', $provider);
    update_option('dworkers_content_seo_agent_ai_images', $images);
    update_option('dworkers_content_seo_agent_ai_model', $model);
    update_option('dworkers_content_seo_agent_generate_category', $generate_category);
    update_option('dworkers_content_seo_agent_activate_seo', $activate_seo);
    update_option('dworkers_content_seo_agent_create_comments', $create_comments);
    update_option('dworkers_content_seo_agent_token', $token);

    return new WP_REST_Response([
        'version' => $version,
        'api_key' => $api_key,
        'provider' => $provider,
        'images' => $images,
        'model' => $model,
        'generate_category' => $generate_category,
        'activate_seo' => $activate_seo,
        'create_comments' => $create_comments,
        'token' => $token,
    ], 200);
}