<?php
/**
 * Plugin Name: Custom Search API
 * Description: Modifica la búsqueda de WordPress para usar una URL personalizada y devolver resultados en JSON sin imágenes.
 * Version: 1.2
 * Author: Lorenalissados
 */

add_action('init', 'custom_search_api_rewrite');
function custom_search_api_rewrite() {
    add_rewrite_rule('^api/search/(.*)', 'index.php?bot=$matches[1]', 'top');
}

add_filter('query_vars', 'custom_search_api_query_vars');
function custom_search_api_query_vars($vars) {
    $vars[] = 'bot';
    return $vars;
}

add_action('template_redirect', 'custom_search_api_template_redirect');
function custom_search_api_template_redirect() {
    $search_query = get_query_var('bot');
    if ($search_query) {
        header('Content-Type: application/json');
        $args = array(
            's' => $search_query,
            'post_type' => array('post', 'page', 'product'),
            'posts_per_page' => -1
        );
        $query = new WP_Query($args);
        $results = array();
        if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();
            $result = array(
                'title' => get_the_title(),
                'link' => get_permalink(),
                'excerpt' => get_the_excerpt(),
                'description' => wp_strip_all_tags(get_the_content(), true) // Strips tags and images
            );
            if ('product' === get_post_type()) {
                $product = wc_get_product(get_the_ID());
                $result['price'] = $product ? $product->get_price() : '';
                $result['sku'] = $product ? $product->get_sku() : '';
            }
            $results[] = $result;
        endwhile; endif;
        wp_reset_postdata();
        echo json_encode($results);
        exit;
    }
}

?>
